//=============================================================================
// SkillEcho.js
// ----------------------------------------------------------------------------
// (C)2025 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2025/02/15 初版
// ----------------------------------------------------------------------------
// [Blog]   : https://ci-en.net/creator/14684
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc スキルエコープラグイン
 * @target MZ
 * @author くろあめ
 * 
 * @param EchoModeStateId
 * @text スキルエコーステート
 * @desc スキルエコー状態になるステートのIDを指定します。
 * @default 0
 * @type number
 *
 * @help
 * 特定のタグを記述したスキル・アイテムを
 * 指定したステート付与中に使用すると
 * スキルの「連続回数」に＋１された状態でスキルが発動します。
 * 
 * エコー対象にしたいスキル・アイテムのメモ欄に
 * <SkillEcho>と記述してください
 * これが記述されたスキル・アイテムを、指定したステート付与中に使うと
 * 本来の連続回数＋１回分、効果が発動します。
 *
 * エコー対象にしたいスキル・アイテムのメモ欄に
 * <SkillEchoTimes:n>と記述してある場合は
 * 本来の連続回数＋n回分、効果が発動します。
 * 
 * エコー発動したスキル・アイテムのMP/TPコストや、消費される戸数は
 * 本来の分（一回の使用分）のみ支払われ
 * エコー発動した分は支払われません。
 *
 *
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

// パラメータ用意
const parameters = PluginManager.parameters('SkillEcho');
const EchoModeStateId = Number(parameters['EchoModeStateId']);

// バトラーの現在のステートのIDのみ配列を取得
Game_BattlerBase.prototype.statesIds = function() {
    return this._states.map(id => $dataStates[id].id);
};

// スキルの連続使用回数を取得し返却する
const _Game_Action_numRepeats  = Game_Action.prototype.numRepeats;
Game_Action.prototype.numRepeats = function() {
  let repeats = _Game_Action_numRepeats.call(this);
  if(this.item() && this.item().meta && this.item().meta.SkillEcho){
      let checkstates = this.subject().statesIds();
      if(checkstates.indexOf(EchoModeStateId) !== -1){
          if(this.item() && this.item().meta && this.item().meta.SkillEchoTimes){
              repeats += this.item().meta.SkillEchoTimes;
          }
          else{
              repeats += 1;
          }
      }
  }
  return Math.floor(repeats);

};

})();

